# Version 2.1 to 2.2

This version update breaks the plugin in a few places.

## Delayed transaction status update

When a transaction is created, it starts with the status `initiated`. The manual payment plugin was setting this status to `pending` while the payment was being received and before the user was redirected to the order complete page. This meant that the transaction couldn't be checked if it had already been processed. The method in EvCheckout is for the order complete page to update the status, the same method has been added in this version as well. This means that the status of the transaction isn't updated until after the user has been redirect. If the method had been extended or required events fired before the user was redirected they will need to be adapted to work with the new method of updating the status.

## New payment complete action

Originally the user would be redirected to `/payment-instructions` once the payment had been received. The user is now redirected to `/manual-payment/complete`. The page still shows the same information to the user but because the action is different, if it had been extended then the new complete action/view will need to be extended. The order id originally provided to the payment instructions has been replaced with the transaction id in the request query data, so if order data is needed the order id will need to be acquired via the transaction.

## Success event

The last change is that the `EvCheckout.Controller.Order.success` event is only called once. This might cause issues as the `AddSuccessfulOrderTemplate` listener is only triggered once which would mean that if the page is refreshed then the order data would be missing. The plugin template doesn't use the order data so by default this won't be a problem unless the payment_instructions view was overridden to show order information. The action will need to be extended and the data loaded from the transaction.
